
#include <stdio.h>

#define MAX_STR 128
#define MAX_PERSONE 1024

typedef char stringa[MAX_STR];

typedef struct {
  int g, m, a;
} data;

typedef struct {
  stringa nominativo;
  data nascita;
} persona;

int leggi_persone(persona *p) {
  int n, k;
  n = 0;
  while (scanf("%[^,], %d/%d/%d\n", p[n].nominativo, 
    &(p[n].nascita.g), &(p[n].nascita.m), &(p[n].nascita.a)) == 4) {
    n++;
    if (n >= MAX_PERSONE) return n;
  }
  return n;
}

int confonta_per_data_di_nascita(persona *p1, persona *p2) {
  if (p1->nascita.a < p2->nascita.a) return -1;
  if (p1->nascita.a > p2->nascita.a) return 1;
  if (p1->nascita.m < p2->nascita.m) return -1;
  if (p1->nascita.m > p2->nascita.m) return 1;
  if (p1->nascita.g < p2->nascita.g) return -1;
  if (p1->nascita.g > p2->nascita.g) return 1;
  return 0;
}

int main() {
  persona p[MAX_PERSONE];
  int n, i;

  n = leggi_persone(p);
  qsort(p, n, sizeof(persona), confonta_per_data_di_nascita);
  for (i = 0; i < 5; i++) {  
    printf("%s, %d/%d/%d\n", p[i].nominativo, p[i].nascita.g, p[i].nascita.m, p[i].nascita.a);
  }
}
