package main

import "bufio"
import "fmt"
import "os"
import "sort"
import "strconv"
import "strings"

type Data struct {
  g, m, a int
}

type Persona struct {
  nominativo string
  nascita Data
}

func confrontaDate(d1, d2 Data) int {
  if d1.a < d2.a {
    return -1
  } else if d1.a > d2.a {
    return 1
  } else if d1.m < d2.m {
    return -1
  } else if d1.m > d2.m {
    return 1
  } else if d1.g < d2.g {
    return -1
  } else if d1.g > d2.g {
    return 1
  } else {
    return 0
  }
}

func str2data(s string) Data {
  var d Data
  pezzi := strings.Split(s, "/")
  d.g, _ = strconv.Atoi(pezzi[0])
  d.m, _ = strconv.Atoi(pezzi[1])
  d.a, _ = strconv.Atoi(pezzi[2])
  return d
}

func leggiPersone() (risultato []Persona) {
  var p Persona
  scanner := bufio.NewScanner(os.Stdin)
  for scanner.Scan() {
    riga := scanner.Text()
    pezzi := strings.Split(riga, ", ")
    p.nominativo = pezzi[0]
    p.nascita = str2data(pezzi[1])
    risultato = append(risultato, p)
  }
  return
}

func (p Persona) String() string {
  return fmt.Sprintf("%s, %d/%d/%d", p.nominativo, p.nascita.g, p.nascita.m, p.nascita.a)
}

func main() {
  p := leggiPersone()
  sort.SliceStable(p, func(i, j int) bool {
    cmp := confrontaDate(p[i].nascita, p[j].nascita)
    return cmp < 0
  })
  for i := 0; i < 5; i++ {
    fmt.Println(p[i])
  }
}

