package integra

import "math/rand"
import "fmt"

func IntegraTrap(f func(float64) float64, a float64, b float64) float64 {
  n := 1000
  delta := (b-a) / float64(n)
  s := 0.0
  for i := 0; i < n; i++ {
    x0 := a + float64(i) * delta
    x1 := x0 + delta
    y0 := f(x0)
    y1 := f(x1)
    s += (y0 + y1) * delta / 2.0
  }
  return s
}

func IntegraMonteCarlo(f func(float64) float64, a float64, b float64) float64 {
  M := 500.0   // Estremo superiore della funzione f nell'intervallo [a,b]
  n := 100000000    // Numero di punti estratti a caso
  sotto := 0
  for i := 0; i < n; i++ {
    x := a + rand.Float64() * (b-a)
    y := rand.Float64() * M
    if y <= f(x) {
      sotto++
    }
  }
  return (b-a) * M * float64(sotto) / float64(n)
}

func main() {
  f := func (x float64) float64 { return 3*x*x + 2 * x + 5 }

  fmt.Println(IntegraTrap(f, 3, 7))
}
