package integra

import "math"
import "testing"

func standardTest(f func(x float64) float64, F func(x float64) float64, a float64, b float64, t *testing.T) {
  actual := IntegraTrap(f, a, b)
  expected := F(b) - F(a)
  if math.Abs(actual - expected) > 1E-4 {
    t.Error("IntegraTrap: Expected ", expected, " actual ", actual)
  }
  actual = IntegraMonteCarlo(f, a, b)
  expected = F(b) - F(a)
  if math.Abs(actual - expected) > 0.5 {
    t.Error("IntegraMonteCarlo: Expected ", expected, " actual ", actual)
  }
}

func TestIntegra(t *testing.T) {  
  f := func (x float64) float64 { return 3*x*x + 2 * x + 5 }
  F := func (x float64) float64 { return x*x*x + x * x + 5 * x }
  standardTest(f, F, 3, 7, t)

  f = math.Sin
  F = func (x float64) float64 { return -math.Cos(x)}
  standardTest(f, F, 0, 1, t)

  f = math.Exp
  F = math.Exp
  standardTest(f, F, 0, 1, t)

}
