package main

import "math/rand"
import "fmt"
import "slices"
import "sort"
import "time"

func generate(n int) (result []int) {
  result = make([]int, n)
  for i := 0; i < n; i++ {
    result[i] = rand.Intn(4 * n)
  }
  return
}

func selectionSort(a []int) {
  n := len(a)
  for i := 0; i < n; i++ {
    min := a[i]
    imin := i
    for j := i + 1; j < n; j++ {
      if a[j] < min {
        min = a[j]
        imin = j
      }
    }
    a[i], a[imin] = a[imin], a[i]
  }
}

func main() {
  for _, n := range []int {10, 100, 1000, 10000, 100000, 1000000} {
    a := generate(n)

    a1 := slices.Clone(a)
    start1 := time.Now()
    sort.Ints(a1)
    end1 := time.Now()
    elapsed1 := end1.Sub(start1)

    a2 := slices.Clone(a)
    start2 := time.Now()
    selectionSort(a2)
    end2 := time.Now()
    elapsed2 := end2.Sub(start2)

    fmt.Printf("%8d\t%10v\t%10v\n", n, elapsed1, elapsed2)
  }
}


