package main

/* Legge da stdin un testo eventualmente di più righe fino a EOF, e stampa la frequenza delle rune che vi compaiono */

import "fmt"
import "bufio"
import "os"
import "unicode"

func main() {
  var m map[rune]int
  m = make(map[rune]int)
  
  scanner := bufio.NewScanner(os.Stdin)

  for scanner.Scan() {
    riga := scanner.Text()
    rigaSlice := []rune(riga)
    for _, runa := range rigaSlice {
      m[unicode.ToLower(runa)]++
    }
  }

  for k, v := range m {
    fmt.Println(string(k), "\t", v)
  }
}

