package main

/* Leggiamo un testo da stdin (fino a EOF) e memorizziamo in una mappa che runa compare dopo ogni
   sequenza di n rune (n è passato come argomento sulla riga di comando). */

import "bufio"
import "fmt"
import "os"
import "strconv"
import "math/rand"

func genera(lm map[string][]string, lung int, n int) string {
  var carattere,s string

  // Scelgo una chiave a caso per iniziare
  interrompiDopo := rand.Intn(len(lm))
  i := 0
  for k,_ := range lm {
    if i == interrompiDopo {
      s = k
      break
    }
    i++
  }

  // Aggiungo i caratteri successivi
  for len(s) < lung {
    caratteriPossibili := lm[s[len(s) - n:]]
    if len(caratteriPossibili) == 0 {
      carattere = " "
    } else {
      carattere = caratteriPossibili[rand.Intn(len(caratteriPossibili))]
    }
    s += carattere
  }
  return s
}

func main() {
  n, _ := strconv.Atoi(os.Args[1])
  
  var lm map[string][]string
  lm = make(map[string][]string)

  scanner := bufio.NewScanner(os.Stdin)
  for scanner.Scan() {
    riga := scanner.Text()
    rigaSlice := []rune(riga)
    for i := 0; i < len(rigaSlice) - n; i++ {
      prefisso := string(rigaSlice[i : i + n])
      lm[prefisso] = append(lm[prefisso], string(rigaSlice[i + n]))
    }
    if len(rigaSlice) >= n {
      lm[string(rigaSlice[len(rigaSlice)-n:])] = append(lm[string(rigaSlice[len(rigaSlice)-n:])], "\n")
    }
  }

  fmt.Println(genera(lm, 1000, n))
    
}
 
