package main

import "fmt"
import "math/rand"
import "os"
import "strconv"

type Try struct {
  attempt string
  rr, rw int
}

func min(x,y int) int {
  if x < y {
    return x
  } else {
    return y
  }
}

/* Compare an attempt to a target string (they have the same length) 
   and computes the number
   of right characters at the right position (rr) and the number
   of right characters at the wrong position */
func compare(attempt string, target string) (rr int, rw int) {
  var m1, m2 map[byte]int

  m1 = make(map[byte]int)
  m2 = make(map[byte]int)

  for i := 0; i < len(attempt); i++ {
    if attempt[i] == target[i] {
      rr++
    } else {
      m1[attempt[i]]++
      m2[target[i]]++
    }
  }

  for k, _ := range m1 {
    rw += min(m1[k], m2[k])
  }
  return 
}

/* Generates and returns a slice of all strings of length n made of digits */
func allAttempts(n int) []string {
  if n == 0 {
    return []string{""}
  } else {
    var res []string
    x := allAttempts(n-1)
    for cifra := '0'; cifra <= '9'; cifra++ {
      for _, y := range x {
        res = append(res, string(cifra)+y)
      }
    }
    return res
  }
}

/* Given a set of Try (attempts with results obtained), produce the set of all
   combinations compatible with the set of Try */
func possibleAttempts(past []Try, nDigits int) []string {
  all := allAttempts(nDigits)
  res := []string{}
  for _, attempt := range all {
    compatible := true 
    for _, try := range past {
      rr, rw := compare(attempt, try.attempt)
      if rr != try.rr || rw != try.rw {
        compatible = false
        break
      }
    }
    if compatible {
      res = append(res, attempt)
    }
  }
  return res
}

func main() {
  nDigits, _ := strconv.Atoi(os.Args[1])

  var tries []Try
  var rr, rw int

  x := allAttempts(nDigits)
  trueTarget := x[rand.Intn(len(x))]
  fmt.Printf("Ho pensato a %s\n", trueTarget)

  for {
    x := possibleAttempts(tries, nDigits)
    attempt := x[rand.Intn(len(x))]
    fmt.Printf("Provo con %s: ", attempt)
    rr, rw = compare(attempt, trueTarget)
    if rr == nDigits {
      fmt.Println("\nTROVATO!")
      break
    }
    fmt.Printf("%d %d\n", rr, rw)
    tries = append(tries, Try{attempt, rr, rw})
  }
}


