package main

import "github.com/holizz/terrapin"
import "image"
import "image/color"
import "image/png"
import "math"
import "os"
import "strconv"

/* Questo programma crea e salva un'immagine PNG vuota il cui nome è passato come unico argomento
   sulla riga di comando */

// go mod init snowflake
// go mod tidy

func kochCurve(t *terrapin.Terrapin, lung float64, liv int) {
  if liv == 0 {
    t.Forward(lung)
  } else {
    kochCurve(t, lung, liv - 1)
    t.Left(math.Pi / 3)
    kochCurve(t, lung, liv - 1)
    t.Right(2 * math.Pi / 3)
    kochCurve(t, lung, liv - 1)
    t.Left(math.Pi / 3)
    kochCurve(t, lung, liv - 1)
  }
}

func kochSnowflake(t *terrapin.Terrapin, lung float64, liv int) {
  for i := 0; i < 4; i++ {
    kochCurve(t, lung, liv)
    t.Right(math.Pi / 2)
  }
}

func main() {
  nomeFile := os.Args[1]
  lung, _ := strconv.ParseFloat(os.Args[2], 64)
  liv, _ := strconv.Atoi(os.Args[3])

  // Immagine vuota
  img := image.NewRGBA(image.Rect(0, 0, 900, 900))
  for x := 0; x < 900; x++ {
    for y := 0; y < 900; y++ {
      img.Set(x, y, color.RGBA{255, 255, 255, 255})
    }
  }
  
  // Tartaruga
  t := terrapin.NewTerrapin(img, terrapin.Position{450.0, 450.0})
  t.Color = color.RGBA{26, 151, 240, 250}
  kochSnowflake(t, lung, liv)

  // Salvo
  f, _ := os.Create(nomeFile)
  png.Encode(f, img)
  f.Close()
}

