package main

import "image"
import "image/color"
import "image/png"
import "os"

/* Questo programma crea e salva un'immagine PNG vuota il cui nome è passato come unico argomento
   sulla riga di comando */

func main() {

  nomeFile := os.Args[1]

  // Immagine vuota
  img := image.NewRGBA(image.Rect(0, 0, 900, 500))
  
  // Disegno sull'immagine
  for x := 100; x <= 200; x++ {
    for y := 100; y <= 200; y++ {
      img.Set(x, y, color.RGBA{26, 151, 240, 250})
    }
  }


  // Salvo
  f, _ := os.Create(nomeFile)
  png.Encode(f, img)
  f.Close()
}

