package main

import "math/rand"
import "image"
import "image/color"
import "image/png"
import "os"

/* Questo programma crea e salva un'immagine PNG vuota il cui nome è passato come unico argomento
   sulla riga di comando */

func main() {

  nomeFile := os.Args[1]

  // Immagine vuota
  img := image.NewRGBA(image.Rect(0, 0, 900, 500))
  
  // Disegno sull'immagine
  quantiRettangoli := rand.Intn(100)

  for i := 0; i < quantiRettangoli; i++ {
    xFrom := rand.Intn(900)
    yFrom := rand.Intn(500)
    w := rand.Intn(900 - xFrom)
    h := rand.Intn(500 - yFrom)
    r := uint8(rand.Intn(256))
    g := uint8(rand.Intn(256))
    b := uint8(rand.Intn(256))
    for x := xFrom; x < xFrom + w; x++ {
      for y := yFrom; y < yFrom + h; y++ {
        img.Set(x, y, color.RGBA{r, g, b, 255})
      }
    }
  }


  // Salvo
  f, _ := os.Create(nomeFile)
  png.Encode(f, img)
  f.Close()
}

