package main

import "fmt"

type Node struct {
  Value string
  Next *Node
}

/* Given a pointer to the first node of a list, print the list on stdout, one line per element */
func PrintList(first *Node) {
  var curs *Node
  for curs = first; curs != nil; curs = curs.Next {
    if curs.Next == nil {
      fmt.Printf("%s\n", curs.Value)
    } else {
      fmt.Printf("%s -> ", curs.Value)
    }
  }
}

/* Adds a new node with value v at the end of the list whose first element is pointed to 
   by first. It returns the new pointer to the first element (possibly it coincides
   with the value passed as first argument). */
func AddLast(first *Node, v string) *Node {
  var curs, newNode *Node

  newNode = new(Node)
  newNode.Value = v
  newNode.Next = nil

  // First case: the list is currently empty and I am just creating a new one-element list
  if first == nil {
    return newNode
  }

  // Second case: I look for the last element of the list and append the new node there
  for curs = first; curs.Next != nil; curs = curs.Next {
  }
  // Now curs points to the very last node
  curs.Next = newNode
  return first
}

func Len(first *Node) int {
  var count int
  for curs := first; curs != nil; curs = curs.Next {
    count++
  }
  return count
}

func AddFirst(first *Node, v string) *Node {
  newNode := new(Node)
  newNode.Value = v
  newNode.Next = first
  // Alternatively: *newNode = {v, first}
  return newNode
}

/* Adds a new node to the list whose first element is pointed at by first, in 
   lexicographic order. It returns the first new node. */
func AddInOrder(first *Node, v string) *Node {
  if first == nil || v <= first.Value {
    return AddFirst(first, v)
  }

  newNode := new(Node)
  newNode.Value = v
  var curs *Node
  // Scan list until the next element after curs becomes larger than v
  // or until the end of the list (curs points to the last element)
  for curs = first; curs.Next != nil && curs.Next.Value <=v; curs = curs.Next {
  }
  if curs.Next == nil {  // We must add the new node at the end
    curs.Next = newNode
    return first
    // Alternatively, we might return AddLast(first, v)
  }
  // We add the new node immediately after curs
  newNode.Next = curs.Next
  curs.Next = newNode
  return first
}

func main() {
  var first *Node

  fmt.Printf("Lunghezza della lista: %d\n", Len(first))
  first = AddLast(first, "amore")
  first = AddLast(first, "guerra")
  first = AddLast(first, "paolo")
  first = AddLast(first, "quadro")
  PrintList(first)
  fmt.Printf("Lunghezza della lista: %d\n", Len(first))
  first = AddFirst(first, "abate")
  PrintList(first)
  fmt.Printf("Lunghezza della lista: %d\n", Len(first))
  fmt.Println("Adesso aggiungo un po' di elementi a caso nella lista e controllo che rimanga in ordine")
  first = AddInOrder(first, "ciao")
  first = AddInOrder(first, "come")
  first = AddInOrder(first, "stai")
  first = AddInOrder(first, "zio")
  first = AddInOrder(first, "io")
  first = AddInOrder(first, "abbastanza")
  first = AddInOrder(first, "bene")
  first = AddInOrder(first, "ma")
  first = AddInOrder(first, "ho")
  first = AddInOrder(first, "un")
  first = AddInOrder(first, "po'")
  first = AddInOrder(first, "di")
  first = AddInOrder(first, "raffreddore")
  PrintList(first)
  fmt.Printf("Lunghezza della lista: %d\n", Len(first))
}

