package main

import "bufio"
import "fmt"
import "os"
import "strconv"
import "strings"

/* Una data è una data, composta da giorno (1-31), mese (1-12), anno */
type data struct {
  g, m, a int
}

/* Restituisce true se l'anno è bisestile */
func isBisestile(a int) bool {
  return a % 4 == 0 && (a % 100 != 0 || a % 400 == 0)
}

/* Restituisce la lunghezza in giorni del mese m nell'anno a. */
func lunghezzaMese(m, a int) int {
  switch m {
    case 11, 4, 6, 9:
      return 30
    case 2:
      max := 28
      if isBisestile(a)  {
        max = 29
      } 
      return max
    default: 
      return 31
  }
}

/* Crea una data a partire da g, m, a */
func newData(g, m, a int) (d data, ok bool) {
  ok = false   // Evitabile
  if m < 1 || m > 12 || g < 1 || g > 31{
    return 
  }
  if g > lunghezzaMese(m, a) {
    return
  }
  ok = true
  d = data {g, m, a}
  return
}

/* Trasforma una data in stringa */
func data2string(d data) string {
    return strconv.Itoa(d.g) + "/" + strconv.Itoa(d.m) + "/" + strconv.Itoa(d.a)
}

func string2data(s string) (d data, ok bool) {
    barra1 := strings.IndexRune(s, '/')
    if barra1 < 0 {
      return 
    }
    barra2 := strings.IndexRune(s[barra1 + 1:], '/')
    if barra2 < 0 {
      return
    }
    sg := strings.Trim(s[: barra1], " ")
    sm := strings.Trim(s[barra1 + 1 : barra1 + 1 + barra2], " ")
    sa := strings.Trim(s[barra1 + 1 + barra2 + 1:], " ")

    var g, m, a int
    var err error

    g, err = strconv.Atoi(sg)
    if err != nil {
      return
    }
    m, err = strconv.Atoi(sm)
    if err != nil {
      return
    }
    a, err = strconv.Atoi(sa)
    if err != nil {
      return
    }
    d, ok = newData(g, m, a)
    return
}

/* Legge una data nel formato G/M/A dallo scanner (leggendo un'intera riga), stampando
   prima il messaggio msg. Chiede di ripetere l'inserimento se la data è errata, termina ed esce con ok=false
   se l'utente digita <EOF>. */
func inputData(msg string, scanner *bufio.Scanner) (d data, ok bool) {
  fmt.Print(msg)
  for {
    if !scanner.Scan() {
      return
    }
    riga := scanner.Text()
    d, ok = string2data(riga)
    if ok {
      break
    } else {  
      fmt.Print("Data errata! Ripeti inserimento: ")
    }
  } 
  return
}

/* Restituisce i giorni trascorsi dal 1/1/1970 alla data d */
func dateFromEpoch(d data) int {
  c := 0
  for a := 1970; a < d.a; a++ {
    if isBisestile(a) {
      c += 366
    } else {
      c += 365
    }
  }
  for m := 1; m < d.m; m++ {
    c += lunghezzaMese(m, d.a)
  }

  
}

func main() {
  var d1, d2 data
  var ok bool
  
  scanner := bufio.NewScanner(os.Stdin)

  d1, ok = inputData("Inserisci la prima data: ", scanner)
  if !ok {
    os.Exit(1)
  } 
  d2, ok = inputData("Inserisci la seconda data: ", scanner)
  if !ok {
    os.Exit(1)
  } 
  fmt.Println(data2string(d1))
  fmt.Println(data2string(d2))
}

