package main

import "fmt"

////// Lists and their methods

type ListNode struct {
  Value string
  Next *ListNode
}

/* Given a pointer to the first ListNode of a list, returns the string describing the list */
func (first *ListNode) String() string {
  var res string
  var curs *ListNode
  for curs = first; curs != nil; curs = curs.Next {
    if curs.Next == nil {
      res += fmt.Sprintf("%s\n", curs.Value)
    } else {
      res += fmt.Sprintf("%s -> ", curs.Value)
    }
  }
  return res
}

/* Adds a new ListNode with value v at the end of the list whose first element is pointed to 
   by first. It returns the new pointer to the first element (possibly it coincides
   with the value passed as first argument). */
func (first *ListNode) AddLast(v string) *ListNode {
  var curs, newListNode *ListNode

  newListNode = new(ListNode)
  newListNode.Value = v
  newListNode.Next = nil

  // First case: the list is currently empty and I am just creating a new one-element list
  if first == nil {
    return newListNode
  }

  // Second case: I look for the last element of the list and append the new ListNode there
  for curs = first; curs.Next != nil; curs = curs.Next {
  }
  // Now curs points to the very last ListNode
  curs.Next = newListNode
  return first
}

func (first *ListNode) Len() int {
  var count int
  for curs := first; curs != nil; curs = curs.Next {
    count++
  }
  return count
}

func (first *ListNode) AddFirst(v string) *ListNode {
  newListNode := new(ListNode)
  newListNode.Value = v
  newListNode.Next = first
  // Alternatively: *newListNode = {v, first}
  return newListNode
}

/* Adds a new ListNode to the list whose first element is pointed at by first, in 
   lexicographic order. It returns the first new ListNode. */
func (first *ListNode) AddInOrder(v string) *ListNode {
  if first == nil || v <= first.Value {
    return first.AddFirst(v)
  }

  newListNode := new(ListNode)
  newListNode.Value = v
  var curs *ListNode
  // Scan list until the next element after curs becomes larger than v
  // or until the end of the list (curs points to the last element)
  for curs = first; curs.Next != nil && curs.Next.Value <=v; curs = curs.Next {
  }
  if curs.Next == nil {  // We must add the new ListNode at the end
    curs.Next = newListNode
    return first
    // Alternatively, we might return AddLast(first, v)
  }
  // We add the new ListNode immediately after curs
  newListNode.Next = curs.Next
  curs.Next = newListNode
  return first
}

////// Stacks and their methods


type StackNode struct {
  Value string
  Next *StackNode
}

func (top *StackNode) Push(v string) *StackNode {
  newNode := new(StackNode)
  newNode.Value = v
  newNode.Next = top
  return newNode
}

func (top *StackNode) Top() string {
  return top.Value
}

func (top *StackNode) Pop() *StackNode {
  return top.Next
}

func (top *StackNode) Len() int {
  count := 0
  for curs := top; curs != nil; curs = curs.Next {
    count++
  }
  return count
}

func (first *StackNode) String() string {
  var res string
  var curs *StackNode
  for curs = first; curs != nil; curs = curs.Next {
    if curs.Next == nil {
      res += fmt.Sprintf("%s\n", curs.Value)
    } else {
      res += fmt.Sprintf("%s \\|/ ", curs.Value)
    }
  }
  return res
}


////// MAIN

type HasLen interface {
  Len() int
}


func averageLength(s []HasLen) float64 {
  somma := 0.0
  for _, t := range s {
    somma += float64(t.Len())
  }
  return somma / float64(len(s))
}


func main() {
  var top *StackNode
  top = top.Push("ciao")
  top = top.Push("mamma")
  top = top.Push("vino")
  fmt.Printf("In cima allo stack c'è %s, la lunghezza è %d\n", top.Top(), top.Len())

  /////
  var first *ListNode

  fmt.Printf("Lunghezza della lista: %d\n", first.Len())
  first = first.AddLast("amore")
  first = first.AddLast("guerra")
  first = first.AddLast("paolo")
  first = first.AddLast("quadro")
  fmt.Println(first)
  fmt.Printf("Lunghezza della lista: %d\n", first.Len())
  first = first.AddFirst("abate")
  fmt.Println(first)
  fmt.Printf("Lunghezza della lista: %d\n", first.Len())
  fmt.Println("Adesso aggiungo un po' di elementi a caso nella lista e controllo che rimanga in ordine")
  first = first.AddInOrder("ciao")
  first = first.AddInOrder("come")
  first = first.AddInOrder("stai")
  first = first.AddInOrder("zio")
  first = first.AddInOrder("io")
  first = first.AddInOrder("abbastanza")
  first = first.AddInOrder("bene")
  first = first.AddInOrder("ma")
  first = first.AddInOrder("ho")
  first = first.AddInOrder("un")
  first = first.AddInOrder("po'")
  first = first.AddInOrder("di")
  first = first.AddInOrder("raffreddore")
  fmt.Println(first)
  fmt.Printf("Lunghezza della lista: %d\n", first.Len())


  /////
  var t []HasLen
  t = append(t, top)
  t = append(t, first)
  fmt.Printf("Lunghezza media di stack e lista: %.3f\n", averageLength(t))

  fmt.Printf("%v\n", first)
  fmt.Println(top)
}

