package main

import "bufio"
import "fmt"
import "os"
import "strings"


/* Legge un file passato come primo argomento, una riga per volta,(ASCII)
   e produce un file passato come secondo argomento.
   Il file conterrà le stesse righe, ma ogni riga sarà preceduta dal numero di caratteri
   e ogni vocale minuscola sarà sostituita con una u */

func garibaldizza(riga string) string {
  var s string
  s = riga
  for _, v := range []string{"a", "e", "i", "o"} {  
    s = strings.ReplaceAll(s, v, "u")
  }
  return s
}

func main() {
  nomeFileDiInput := os.Args[1]
  nomeFileDiOutput := os.Args[2]
  fin, _ := os.Open(nomeFileDiInput)
  fout, _ := os.Create(nomeFileDiOutput)
  defer fin.Close()
  defer fout.Close()

  scanner := bufio.NewScanner(fin)
  for scanner.Scan() {
    riga := scanner.Text()
    rigaTrasformata := garibaldizza(riga)
    fmt.Fprintf(fout, "%5d %s\n", len(riga), rigaTrasformata)
  }
}
