package main

import "fmt"
import "io"
import "os"

/* Questo programma legge il file il cui nome viene passato sulla riga di comando 100 byte per volta,
   e ogni volta stampa i byte letti. */

func main() {
  nomeFile := os.Args[1]
  f, err := os.Open(nomeFile)
  defer f.Close()
  if err != nil {
    fmt.Printf("*** ERRORE %v\n", err)
    os.Exit(1)
  }

  // Leggiamo il file
  var b []byte
  b = make([]byte, 100)
  for {
    n, err := f.Read(b)
    if err == io.EOF {
      break
    }
    fmt.Printf("Numero di byte letti: %d\n", n)
    fmt.Printf("Errore: %v\n", err)
    fmt.Printf("Slice: %s\n\n", string(b[:n]))
  }
  
}
