package main

import "fmt"
import "os"
import "strconv"

/* Data una slice di interi, ne calcola e restituisce la media */
func media(x []int) float64 {
  var s int
  for _, v := range x {
    s += v
  }
  return float64(s)/float64(len(x))
}

/* Leggo gli  argomenti sulla riga di comando (che devono essere degli interi) 
   e ne stampo la media */
func main() {
  var s []int
  var err error
  s = make([]int, len(os.Args) - 1)
  
  for i, a := range os.Args[1:] {
    s[i], err = strconv.Atoi(a)
    if err != nil {
      fmt.Println("Non sono riuscito a convertire", a, ": assumerò che sia 0")
      s[i] = 0
    }
  }
  fmt.Println(media(s))
}






