package main

import "fmt"
import "math/rand"
import "os"
import "strconv"
import "strings"
import "time"

/* Stampa la stanza di dimensione n x n, e mette la mosca in posizione (x,y), dove x è
   la posizione orizzontale (da 0 a n-1) e y è la posizione verticale (da 0 a n-1) */
func stampaStanza(n, x, y int) {
  fmt.Print("\u001B[2J\u001B[H")
  fmt.Print("\u250c" + strings.Repeat("\u2500", n) + "\u2510\n")
  for i := 0; i < n; i++ {
    if i == y {
      fmt.Print("\u2502" + strings.Repeat(" ", x) + "*" + strings.Repeat(" ", n - x - 1)  + "\u2502\n")
    } else {
      fmt.Print("\u2502" + strings.Repeat(" ", n) + "\u2502\n")
    }
  }
  fmt.Print("\u2514" + strings.Repeat("\u2500", n) + "\u2518\n")
}

/* Sulla riga di comando deve essere presente la dimensione della stanza in cui si muove la mosca */
func main() {
  var n, x, y int
  var err error
  
  if len(os.Args) != 2 {
    fmt.Println("Numero di argomenti errato")
    os.Exit(1)
  }
  n, err = strconv.Atoi(os.Args[1]) 
  if err != nil || n == 0 || n > 100{
    fmt.Println("Valore errato o non convertibile")
    os.Exit(1)
  }

  x = rand.Intn(n)
  y = rand.Intn(n)

  for {
    stampaStanza(n, x, y)
    switch rand.Intn(4) {
      case 0:
        x++
        if x >= n {
          x--
        }
      case 1:
        x--
        if x < 0 {
          x++
        }
      case 2:
        y++
        if y >= n {
          y--
        }
      case 3:
        y--
        if y < 0 {
          y++
        }
    }
    time.Sleep(1 * time.Millisecond)
  }
}
