package main

import "fmt"
import "math/rand"

/* Un mazzo è una sequenza (rappresentata come una slice) di carte */
type mazzo []carta

/* Restituisce un mazzo con tutte le carte da poker, nell'ordine da quella minima a quella massima */
func mazzoIntero() mazzo {
  var m mazzo
  for s := 0; s < 4; s++ {
    for v := 0; v < 13; v++ {
      m = append(m, carta{seme: s, valore: v})
    }
  }
  return m
}

/* Restituisce un mazzo con tutte le carte da poker, nell'ordine da quella minima a quella massima, 
   limitandosi a quelle di valore >= valoreMinimo */
func mazzoDaPoker(valoreMinimo int) mazzo {
  var m mazzo
  for s := 0; s < 4; s++ {
    for v := valoreMinimo; v < 13; v++ {
      m = append(m, carta{seme: s, valore: v})
    }
  }
  return m
}

/* La funzione rimescola il contenuto del mazzo passato come argomento a caso */
func mescola(m mazzo) {
  for i := 0; i < len(m); i++ {
    // Scambio m[i] con una carta m[j] scegliendo j a caso fra i e len(m)-1
    j := i + rand.Intn(len(m) - i)
    m[i], m[j] = m[j], m[i]
  }
}

/* Prende le prime n carte da m e le restituisce sottoforma di mazzo */
func servi(m mazzo, n int) mazzo {
  var r mazzo
  for i := 0; i < n; i++ {
    r = append(r, m[i])
  }
  return r
}

/* Stampa il mazzo m nell'ordine, numerandone le carte */
func stampaMazzo(m mazzo) {
  for i, c := range m {
    fmt.Print(i, ") ", String(c), "\n")
  }
}
 
